package gov.va.vinci.dart.json.builder;

import java.util.Calendar;
import java.util.GregorianCalendar;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import com.ibm.icu.text.SimpleDateFormat;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.RequestLocationDocumentSummary;
import gov.va.vinci.dart.biz.RequestParticipantDocumentSummary;
import gov.va.vinci.dart.json.DocumentVersionView;
import gov.va.vinci.dart.json.DocumentView;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestDocumentViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		DocumentViewBuilder builder = new DocumentViewBuilder();
		
		try {
			builder.build((RequestLocationDocumentSummary)null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}
		
		RequestLocationDocumentSummary rlds = new RequestLocationDocumentSummary();
		rlds.setDocumentId(1);
		rlds.setHeadId(2);
		rlds.setVersionNumber(3);
		rlds.setSortOrder(4);
		rlds.setReviewNoteCreatedOn(new java.sql.Timestamp(System.currentTimeMillis()));
		rlds.setReviewNote("note");
		rlds.setReviewStatus("review status");
		rlds.setDocumentName("document name");
		rlds.setUpdatedBy("updatedBy");
		rlds.setUpdatedOn(new java.sql.Timestamp(System.currentTimeMillis()));
		rlds.setCreatedBy("createdBy");
		rlds.setCreatedOn(new java.sql.Timestamp(System.currentTimeMillis()));
		
		DocumentView dvv = builder.build(rlds);
		Assert.assertNotNull(dvv);
		Assert.assertEquals(dvv.getId(), 1);
		Assert.assertEquals(dvv.getHeadId(), 2);
		Assert.assertEquals(dvv.getVersionNumber(), 3);
		Assert.assertEquals(dvv.getSortOrder(), 4);
		Assert.assertEquals(dvv.getName(), "document name");
		Assert.assertEquals(dvv.getUpdatedBy(), "updatedBy");
		Assert.assertEquals(dvv.getDocType(), "File Document");
		Assert.assertEquals(dvv.getReviewStatus(), "review status");
		Assert.assertTrue(dvv.isUploaded());

		// verify that the date is formatted MM/dd/yy hh:mmaa
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy hh:mmaa");
		java.util.Date date = sdf.parse(dvv.getUpdatedOn());
		GregorianCalendar gc = new GregorianCalendar();
		gc.setTime(date);
		
		//commented out this test, because we cannot guarantee that this test will only be run during 2013
		//Assert.assertEquals(gc.get(Calendar.YEAR), 2013);
		GregorianCalendar currCalendar = new GregorianCalendar();
		Assert.assertEquals(gc.get(Calendar.YEAR), currCalendar.get(Calendar.YEAR));		
		
		// verify that the date is formatted MM/dd/yy hh:mmaa
		SimpleDateFormat sdf2 = new SimpleDateFormat("MM/dd/yyyy");  // two different date formats - seriously?
		date = sdf2.parse(dvv.getCreatedOn());
		gc = new GregorianCalendar();
		gc.setTime(date);
		
		//commented out this test, because we cannot guarantee that this test will only be run during 2013
		//Assert.assertEquals(gc.get(Calendar.YEAR), 2013);
		Assert.assertEquals(gc.get(Calendar.YEAR), currCalendar.get(Calendar.YEAR));		
	}

	@Test
	public void testTwo() throws Exception {
		DocumentViewBuilder builder = new DocumentViewBuilder();
		
		try {
			builder.build((RequestParticipantDocumentSummary)null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}
	
		RequestParticipantDocumentSummary rpds = new RequestParticipantDocumentSummary();
		
		rpds.setDocumentId(1);
		rpds.setHeadId(2);
		rpds.setVersionNumber(3);
		rpds.setSortOrder(4);
		rpds.setReviewNoteCreatedOn(new java.sql.Timestamp(System.currentTimeMillis()));
		rpds.setReviewNote("note");
		rpds.setReviewStatus("review status");
		rpds.setDocumentName("document name");
		rpds.setUpdatedBy("updatedBy");
		rpds.setUpdatedOn(new java.sql.Timestamp(System.currentTimeMillis()));
		rpds.setCreatedBy("createdBy");
		rpds.setCreatedOn(new java.sql.Timestamp(System.currentTimeMillis()));
		
		DocumentView dvv = builder.build(rpds);
		Assert.assertNotNull(dvv);
		Assert.assertEquals(dvv.getId(), 1);
		Assert.assertEquals(dvv.getHeadId(), 2);
		Assert.assertEquals(dvv.getVersionNumber(), 3);
		Assert.assertEquals(dvv.getSortOrder(), 4);
		Assert.assertEquals(dvv.getName(), "document name");
		Assert.assertEquals(dvv.getUpdatedBy(), "updatedBy");
		Assert.assertEquals(dvv.getDocType(), "File Document");
		Assert.assertEquals(dvv.getReviewStatus(), "review status");
		Assert.assertTrue(dvv.isUploaded());

		// verify that the date is formatted MM/dd/yy hh:mmaa
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy hh:mmaa");
		java.util.Date date = sdf.parse(dvv.getUpdatedOn());
		GregorianCalendar gc = new GregorianCalendar();
		gc.setTime(date);
		
		//commented out this test, because we cannot guarantee that this test will only be run during 2013
		//Assert.assertEquals(gc.get(Calendar.YEAR), 2013);
		GregorianCalendar currCalendar = new GregorianCalendar();
		Assert.assertEquals(gc.get(Calendar.YEAR), currCalendar.get(Calendar.YEAR));
		
		// verify that the date is formatted MM/dd/yy hh:mmaa
		SimpleDateFormat sdf2 = new SimpleDateFormat("MM/dd/yyyy");  // two different date formats - seriously?
		date = sdf2.parse(dvv.getCreatedOn());
		gc = new GregorianCalendar();
		gc.setTime(date);
		
		//commented out this test, because we cannot guarantee that this test will only be run during 2013
		//Assert.assertEquals(gc.get(Calendar.YEAR), 2013);
		Assert.assertEquals(gc.get(Calendar.YEAR), currCalendar.get(Calendar.YEAR));
	}
	
}
